players = {}
lives = {}
livesConditions = {}
spawnLocale = {}
plrSpawns = {}
activeJeeps = {}
numLives = 0
startingSpawns = true
startingSpawnPositions = {}

Tick = function()
	local plrLoop = 1
	while plrLoop <= #players  do
		local units = players[plrLoop].GetActors()
		local x = 4
		while x <= #units do
			if units[x].Type ~= "jeep2" then
				if units[x].Type ~= "minv" then
					units[x].Teleport(gotohere.Location)
				end
			end
			x = x + 1
		end
		plrLoop = plrLoop + 1
	end
end

UpdateLives = function(playerNumber)
	if lives[playerNumber] > 1 then
		lives[playerNumber] = lives[playerNumber] - 1
		Media.DisplayMessage(players[playerNumber].Name .. " has " .. lives[playerNumber] .. " lives")
		CreateJeep(players[playerNumber], lives[playerNumber], playerNumber)
	elseif lives[playerNumber] == 1 then
		lives[playerNumber] = lives[playerNumber] - 1
		players[playerNumber].GetActorsByType("weap")[1].Destroy()
	elseif lives[playerNumber] < 1 then
	end
end

CreateJeep = function(player, lifeCount, playerNumber)
	local spawnPoint = ChooseSpawnLocation()
	local actor = Actor.Create("jeep2", true, { Owner = player, Location = spawnPoint.Location })
	actor.GrantCondition(livesConditions[lifeCount], 0)
	if player.IsLocalPlayer then
		Camera.Position = actor.CenterPosition
	end
	Trigger.OnKilled(actor, function ()
		UpdateLives(playerNumber)
	end)
end

ChooseSpawnLocation = function()
	local spawnLooper = 1
	local vicinityChecker = {}
	local neighboursToSlot = 1000
	local mostFreeSlot = 0
	local distance = WDist.FromCells(6)
	local possibleSpawns = {}
	local possibleSpawnSaver = 1
	if startingSpawns == false then
		while spawnLooper <= #plrSpawns do
			vicinityChecker = Map.ActorsInCircle(plrSpawns[spawnLooper].CenterPosition, WDist.New(6144), IsJeep)
			if neighboursToSlot >= #vicinityChecker then
				mostFreeSlot = spawnLooper
				if neighboursToSlot == #vicinityChecker then
					possibleSpawns[possibleSpawnSaver] = mostFreeSlot
					possibleSpawnSaver = possibleSpawnSaver + 1
				end
				neighboursToSlot = #vicinityChecker
			end
			spawnLooper = spawnLooper + 1
		end
		if #possibleSpawns > 1 then
			local randomStart = Utils.RandomInteger(1, #possibleSpawns)
			mostFreeSlot = possibleSpawns[randomStart]
		end
	elseif startingSpawns == true then
		local tempStartSpawns = {}
		local spwnLooper = 1
		local spawnInstaller = 1
		local randomStart = Utils.RandomInteger(1, #startingSpawnPositions)
		mostFreeSlot = randomStart
	-- Something goes wrong here should remove used slots
	--	startingSpawnPositions[randomStart] = gotohere
	--	while spawnLooper <= #startingSpawnPositions do
	--		if startingSpawnPositions[randomStart] ~= nil then
	--			tempStartSpawns[spawnInstaller] = startingSpawnPositions[spawnLooper]
	--			spawnInstaller = spawnInstaller + 1
	--		end
	--		spawnLooper = spawnLooper + 1
	--	end
	end
	return plrSpawns[mostFreeSlot]
end

IsJeep = function(actor)
	return actor.Type == "jeep2"
end

DestroyAllPowers = function(player)
	local plractors = player.GetActors()
	local looper = #plractors
	while looper > 2 do
		plractors[looper].Destroy()
		looper = looper - 1
	end
end

InitializePlayers = function()
	players[1] = Player.GetPlayer("Multi0")
	players[2] = Player.GetPlayer("Multi1")
	players[3] = Player.GetPlayer("Multi2")
	players[4] = Player.GetPlayer("Multi3")
	players[5] = Player.GetPlayer("Multi4")
	players[6] = Player.GetPlayer("Multi5")
	spawnLocale[1] = pl1wf.Location
	spawnLocale[2] = pl2wf.Location
	spawnLocale[3] = pl3wf.Location
	spawnLocale[4] = pl4wf.Location
	spawnLocale[5] = pl5wf.Location
	spawnLocale[6] = pl6wf.Location
	plrSpawns[1] = spwn1
	plrSpawns[2] = spwn2
	plrSpawns[3] = spwn3
	plrSpawns[4] = spwn4
	plrSpawns[5] = spwn5
	plrSpawns[6] = spwn6
	livesConditions[1] = "livescntr1"
	livesConditions[2] = "livescntr2"
	livesConditions[3] = "livescntr3"
	livesConditions[4] = "livescntr4"
	livesConditions[5] = "livescntr5"
	livesConditions[6] = "livescntr6"
	livesConditions[7] = "livescntr7"
	livesConditions[8] = "livescntr8"
	livesConditions[9] = "livescntr9"
	livesConditions[10] = "livescntr10"
	livesConditions[11] = "livescntr11"
	livesConditions[12] = "livescntr12"
	livesConditions[13] = "livescntr13"
	livesConditions[14] = "livescntr14"
	livesConditions[15] = "livescntr15"
	livesConditions[16] = "livescntr16"
	livesConditions[17] = "livescntr17"
	livesConditions[18] = "livescntr18"
	livesConditions[19] = "livescntr19"
	livesConditions[20] = "livescntr20"
	startingSpawnPositions = plrSpawns
	local plrsLoopz = 1
	while plrsLoopz <= #players do
		lives[plrsLoopz] = numLives
		local actor = Actor.Create("weap", true, { Owner = players[plrsLoopz], Location = spawnLocale[plrsLoopz] })
		local sMcv = players[plrsLoopz].GetActorsByType("mcv")[1]
		sMcv.Destroy()
		UpdateLives(plrsLoopz)
		plrsLoopz = plrsLoopz + 1
	end
end

WorldLoaded = function()
	if Map.LobbyOption("livesID") == "a" then
		numLives = 2
	elseif Map.LobbyOption("livesID") == "g" then
		numLives = 4
	elseif Map.LobbyOption("livesID") == "b" then
		numLives = 6
	elseif Map.LobbyOption("livesID") == "c" then
		numLives = 11
	elseif Map.LobbyOption("livesID") == "d" then
		numLives = 16
	elseif Map.LobbyOption("livesID") == "e" then
		numLives = 21
	end
	InitializePlayers()
end